var ErrMessage = {
      0: '',
      1: '缺少参数',
      2: '参数格式错误',
      3: '坐标错误',
      4: '未知类型',
      5: '物品信息错误，创建物品失败',
      6: 'BotID或者Token错误',
      7: '用户名密码错误',
      8: '玩家信息拉取失败',
      9: '物品错误',
      10: '没有足够的积分',
      11: '货架格子已满',
      12: '玩家角色已死亡',
      13: '数据错误',
      14: '物品不允许上架',
      15: '货架已满',
      16: '服务器繁忙，请稍后再试',
      17: '操作已超时',
      18: '操作失败，操作已回滚',
      19: '物品已存在',
      254: '处理请求错误，请查看服务端日志',
      255: '云端通信错误'
}

function ApiResult(data, status, text){
      var errMsg = '';

      if(status == "success") {
          var jsonObj = JSON.parse(data);
          if(jsonObj) {
              if(jsonObj.result == 1) {
                  if(text) {
                      layer.msg(`${text}成功`);
                  }
                  return jsonObj;
              } else {
                  if(jsonObj.errcode) {
                        errMsg = ErrMessage[jsonObj.errcode];
                  }
              }
          }
      }

      if(text) {
            if(errMsg && errMsg.length > 0) {
                  layer.msg(`${text}失败: ${errMsg}`);
            } else {
                  layer.msg(`${text}失败`);
            }
      }

      return null;
  }