layui.config({
  layimPath: 'layim/'
  ,layimAssetsPath: 'js/lay-module/layim/assets/'
}).extend({
  layim: layui.cache.layimPath + 'layim'
}).use('layim', function(layim){
  var layim = layui.layim;
  
  //基础配置
  layim.config({
    //初始化接口
    init: {
      url: `/api/livechat_init?key=${sessionStorage.getItem('sessionKey')}`
      ,data: {}
    }
    //查看群员接口
    ,members: {
      url: `/api/livechat_publicmembers?key=${sessionStorage.getItem('sessionKey')}`
      ,data: {}
    }
    
    ,isAudio: false //开启聊天工具栏音频
    ,isVideo: false //开启聊天工具栏视频
    
    //,brief: true //是否简约模式（若开启则不显示主面板）
    
    ,title: '<span style="font-size:14px;font-weight:700">实时聊天</span>' //自定义主面板最小化时的标题
    //,right: '100px' //主面板相对浏览器右侧距离
    //,minRight: '90px' //聊天面板最小化时相对浏览器右侧距离
    ,initSkin: 'skin.jpg'
    //,skin: ['aaa.jpg'] //新增皮肤
    ,isfriend: false //是否开启好友
    //,isgroup: false //是否开启群组
    ,min: true //是否始终最小化主面板，默认false
    //,notice: true //是否开启桌面消息提醒，默认false
    ,voice: false //声音提醒，默认开启，声音文件为：default.mp3
    
    //,msgbox: layui.cache.layimAssetsPath + 'html/msgbox.html' //消息盒子页面地址，若不开启，剔除该项即可
    //,find: layui.cache.layimAssetsPath + 'html/find.html' //发现页面地址，若不开启，剔除该项即可
    ,chatLog: '/page/livechat_log.html' //聊天记录页面地址，若不开启，剔除该项即可
    
  });

  var Pullid = -1;
 
  const chatMsgProc = (jsonData) => {
    if(jsonData.count == 0 && Pullid == -1) {
      Pullid = 0;
      return true;
    }
    var bFirst = (Pullid == -1);
    if(!jsonData.data)
      return false;

    var PushMessage = layim.getMessage;
    if(Pullid == -1) {
      PushMessage = layim.getMessage_notNotice;
    }

    for(var i = 0; i < jsonData.data.length; i += 1) {
      if(bFirst || (!bFirst && jsonData.data[i].ia == 0)) {
        if(jsonData.data[i].type == 3) {
          var msgObj = {
            username: jsonData.data[i].pn, 
            avatar: "", 
            id: jsonData.data[i].uid, 
            type: "friend", 
            content: jsonData.data[i].msg, 
            timestamp: parseInt(jsonData.data[i].t),
            mine: jsonData.data[i].ia == 0 ? false : true
          };
          PushMessage(msgObj);
        }
        else
        {
          var tags = '';
          if(jsonData.data[i].type == 0) {
            tags = '(公共)';
          } else if(jsonData.data[i].type == 1) {
            tags = '(好友)';
          } else if(jsonData.data[i].type == 2) {
            tags = '(组队)';
          }
          
          var msgObj = {
            username: `${jsonData.data[i].pn}${tags}`,
            avatar: "",
            id: "group_0",
            type: "group",
            mine: jsonData.data[i].ia == 0 ? false : true,
            content: jsonData.data[i].msg,
            timestamp: parseInt(jsonData.data[i].t)
          }
          layim.getMessage_notNotice(msgObj);
        }
      }

      if(jsonData.data[i].id >= Pullid) {
        Pullid = jsonData.data[i].id + 1;
      }
    }
    
    return true;
  }

  const chatMsgPull = () => {
    var sessKey = sessionStorage.getItem('sessionKey')
    $.get(`api/livechat_pull?key=${sessKey}&id=${Pullid}`,function(data,status){
        if(status == "success") {
            var jsonObj = JSON.parse(data);
            if(jsonObj) {
                if(jsonObj.result == 1) {
                  var ret = chatMsgProc(jsonObj);
                  if(ret) {
                    setTimeout(chatMsgPull, 1);
                    return;
                  }
                }
            }
        }
        setTimeout(chatMsgPull, 3000);
    });
  }

  const chatSendMessage = (toid, msg) => {
    sessKey = sessionStorage.getItem('sessionKey')
    $.get(`api/livechat_sendmessage?key=${sessKey}&to=${toid}&msg=${NaiwaziUrlEncode(msg)}`,function(data,status){
        if(status == "success") {
            var jsonObj = JSON.parse(data);
            if(jsonObj) {
                if(jsonObj.result == 1) {
                  return;
                }
            }
        }
        layui.layer.msg("您的消息发送失败!");
    });
  }

  //监听layim建立就绪
  layim.on('ready', function(res){
    //console.log(res.mine);
    chatMsgPull();
  });

  //监听发送消息
  layim.on('sendMessage', function(data){
    
    chatSendMessage(data.to.id, data.mine.content);
    /*
    setTimeout(function(){
      var obj = {};
      if(To.type === 'group'){
        obj = {
          username: '模拟群员'+(Math.random()*100|0)
          ,avatar: layui.cache.layimAssetsPath + 'images/face/'+ (Math.random()*72|0) + '.gif'
          ,id: To.id
          ,type: To.type
          ,content: autoReplay[Math.random()*9|0]
        }
      } else {
        obj = {
          username: To.name
          ,avatar: To.avatar
          ,id: To.id
          ,type: To.type
          ,content: autoReplay[Math.random()*9|0]
        }
        layim.setChatStatus('<span style="color:#FF5722;">在线</span>');
      }
      layim.getMessage(obj);
    }, 1000);
    */
  });
  
  //监听聊天窗口的切换
  layim.on('chatChange', function(res){
    var type = res.data.type;
    if(type === 'friend'){
      
    } else if(type === 'group'){

    }
  });
  
  
  //面板外的操作
  var $ = layui.jquery, active = {
    chat: function(){
      //自定义会话
      layim.chat({
        name: '小测试'
        ,type: 'friend'
        ,avatar: '//tva3.sinaimg.cn/crop.0.0.180.180.180/7f5f6861jw1e8qgp5bmzyj2050050aa8.jpg'
        ,id: 1008612
      });
      layer.msg('也就是说，此人可以不在好友面板里');
    }
    ,message: function(){
      //制造好友消息
      layim.getMessage({
        username: "测试1"
        ,avatar: "//res.layuion.com/images/fly/avatar/default.png"
        ,id: "100001"
        ,type: "friend"
        ,content: "嗨，你好！这是一条测试内容。演示标记："+ new Date().getTime()
        ,timestamp: new Date().getTime()
      });
    }
    ,messageAudio: function(){
      //接受音频消息
      layim.getMessage({
        username: "测试1"
        ,avatar: "//res.layuion.com/images/fly/avatar/default.png"
        ,id: "100001"
        ,type: "friend"
        ,content: "audio[http://gddx.sc.chinaz.com/Files/DownLoad/sound1/201510/6473.mp3]"
        ,timestamp: new Date().getTime()
      });
    }
    ,messageVideo: function(){
      //接受视频消息
      layim.getMessage({
        username: "测试1"
        ,avatar: "//res.layuion.com/images/fly/avatar/default.png"
        ,id: "100001"
        ,type: "friend"
        ,content: "video[http://www.w3school.com.cn//i/movie.ogg]"
        ,timestamp: new Date().getTime()
      });
    }
    ,messageTemp: function(){
      //接受临时会话消息
      layim.getMessage({
        username: "测试X"
        ,avatar: "//res.layuion.com/images/fly/avatar/default.png"
        ,id: "198909151014"
        ,type: "friend"
        ,content: "临时："+ new Date().getTime()
      });
    }
    ,add: function(){
      //实际使用时数据由动态获得
      layim.add({
        type: 'friend'
        ,username: '测试Y'
        ,avatar: '//res.layuion.com/images/fly/avatar/default.png'
        ,submit: function(group, remark, index){
          layer.msg('好友申请已发送，请等待对方确认', {
            icon: 1
            ,shade: 0.5
          }, function(){
            layer.close(index);
          });
          
          //通知对方
          /*
          $.post('/im-applyFriend/', {
            uid: info.uid
            ,from_group: group
            ,remark: remark
          }, function(res){
            if(res.status != 0){
              return layer.msg(res.msg);
            }
            layer.msg('好友申请已发送，请等待对方确认', {
              icon: 1
              ,shade: 0.5
            }, function(){
              layer.close(index);
            });
          });
          */
        }
      });
    }
    ,addqun: function(){
      layim.add({
        type: 'group'
        ,username: '测试群组1'
        ,avatar: '//res.layuion.com/images/fly/avatar/default.png'
        ,submit: function(group, remark, index){
          layer.msg('申请已发送，请等待管理员确认', {
            icon: 1
            ,shade: 0.5
          }, function(){
            layer.close(index);
          });
          
          //通知对方
          /*
          $.post('/im-applyGroup/', {
            uid: info.uid
            ,from_group: group
            ,remark: remark
          }, function(res){
          
          });
          */
        }
      });
    }
    ,addFriend: function(){
      var user = {
        type: 'friend'
        ,id: 1234560
        ,username: '测试A' //好友昵称，若申请加群，参数为：groupname
        ,avatar: '//res.layuion.com/images/fly/avatar/default.png' //头像
        ,sign: '测试内容'
      }
      layim.setFriendGroup({
        type: user.type
        ,username: user.username
        ,avatar: user.avatar
        ,group: layim.cache().friend //获取好友列表数据
        ,submit: function(group, index){
          //一般在此执行Ajax和WS，以通知对方已经同意申请
          //……
          
          //同意后，将好友追加到主面板
          layim.addList({
            type: user.type
            ,username: user.username
            ,avatar: user.avatar
            ,groupid: group //所在的分组id
            ,id: user.id //好友ID
            ,sign: user.sign //好友签名
          });
          
          layer.close(index);
        }
      });
    }
    ,addGroup: function(){
      layer.msg('已成功把[测试群组33]添加到群组里', {
        icon: 1
      });
      //增加一个群组
      layim.addList({
        type: 'group'
        ,avatar: "//res.layuion.com/images/fly/avatar/default.png"
        ,groupname: '测试群组33'
        ,id: "12333333"
        ,members: 0
      });
    }
    ,removeFriend: function(){
      layer.msg('已成功删除[测试2]', {
        icon: 1
      });
      //删除一个好友
      layim.removeList({
        id: 100001222
        ,type: 'friend'
      });
    }
    ,removeGroup: function(){
      layer.msg('已成功删除[测试群组33]', {
        icon: 1
      });
      //删除一个群组
      layim.removeList({
        id: 12333333
        ,type: 'group'
      });
    }
    //置灰离线好友
    ,setGray: function(){
      layim.setFriendStatus(168168, 'offline');
      
      layer.msg('已成功将好友[测试4]置灰', {
        icon: 1
      });
    }
    //取消好友置灰
    ,unGray: function(){
      layim.setFriendStatus(168168, 'online');
      
      layer.msg('成功取消好友[测试4]置灰状态', {
        icon: 1
      });
    }
    //移动端版本
    ,mobile: function(){
      var device = layui.device();
      var mobileHome = '/layim/pro/demo/mobile.html';
      if(device.android || device.ios){
        return location.href = mobileHome;
      }
      var index = layer.open({
        type: 2
        ,title: '移动版演示 （或手机扫右侧二维码预览）'
        ,content: mobileHome
        ,area: ['375px', '667px']
        ,shadeClose: true
        ,scrollbar: false
        ,shade: 0.8
        ,end: function(){
          layer.close(index + 2);
        }
      });
    }
  };
  $('.site-demo-layim').on('click', function(){
    var type = $(this).data('type');
    active[type] ? active[type].call(this) : '';
  });
});