var NaiwaziEditor_BlockDeclare = `
      declare class NaiwaziObject_Block {
            /**
             *  获取原生模式编程的物块类对象
             */
            gameobject: any;

            /**
             *  物块的数字ID
             */
             blockid: Number;

            /**
             *  物块名称
             */
             blockname: string;
            
            /**
             *  物块的朝向
             */
             rotation: Number;

            /**
             *  物块已损失的耐久
             */
            damage: Number;

            /**
             *  物块最大耐久
             */
            maxdamage: Number;
      }
`;

var NaiwaziEditor_ItemDeclare = `
      declare class NaiwaziObject_Item {
            /**
             *  获取原生模式编程的物品类对象
             */
            gameobject: any;

            /**
             *  物品数量
             */
             count: Number;

            /**
             *  物品名称
             */
             name: string;
            
            /**
             *  物品ID
             */
             id: Number;

            /**
             *  物品品质
             */
             quality: Number;

            /**
             *  物品附加数据
             */
             metadata: Number;

            /**
             *  最大使用次数
             */
             maxusetimes: Number;

            /**
             *  物品是否属于模组
             */
             is_mod: Boolean;
             
            /**
             *  物品是否拥有模组
             */
             has_mods: Boolean;

            /**
             *  物品属性的随机数种子
             */
             seed: Number;

            /**
             * 获取物品上附有的所有模组列表\n
             * @return {Array<NaiwaziObject_Item>}
             */
             GetModifications();
      }
`;


var NaiwaziEditor_EntityDeclare = `
      declare class NaiwaziObject_Entity {
            /**
             *  是否属于EntityAlive (有生命的实体)
             */
            IS_ALIVE: Boolean;
            /**
             *  是否属于EntityPlayer (玩家实体)
             */
            IS_PLAYER: Boolean;
            /**
             *  是否属于EntityEnemy (敌对实体，指会主动攻击玩家的实体)
             */
            IS_ENEMY: Boolean;
            /**
             *  是否属于EntityZombie (僵尸类实体)
             */
            IS_ZOMBIE: Boolean;
            /**
             *  是否属于EntityAnimal (动物类实体)
             */
            IS_ANIMAL: Boolean; 
            /**
             *  是否属于EntityItem (物品类实体)
             */
            IS_ITEM: Boolean; 
            
            /**
             *  获取原生模式编程的实体类对象
             */
            gameobject: any;
            
            /**
             *  获取该实体的坐标（X）
             */
            x: Number;

            /**
             *  获取该实体的坐标（Y）
             */
            y: Number;

            /**
             *  获取该实体的坐标（Z）
             */
            z: Number;

            /**
             *  获取该实体的EntityID
             */
            entityid: Number;
            
            /**
             *  实体是否死亡
             */
            is_dead: Boolean;

            /**
             *  获取实体的承重重量
             */
            weight: Number;

            /**
             *  实体是否正在驾驶载具
             */
            is_driven: Boolean;

            /**
             *  实体是否处于水中
             */
            is_inwater: Boolean;

            /**
             *  实体是否处于垂直爬升工具中，如梯子等
             */
            is_inelevator: Boolean;
            
            /**
             *  实体是否已在地图上生成
             */
            is_spawned: Boolean;

            /**
             *  是否属于远程实体（本地实体指的是在服务器上生成的实体，如僵尸等，远程实体指的是在客户端生成的实体，如玩家等）
             */
            is_remote: Boolean;
            
            /**
             *  实体在XML中定义的标签（tag）
             */
            tags: string;

            /**
             *  实体类型的哈希值，通常用于比较两个实体是否是同类
             */
            entityclass_hash: Number;

            /**
             * 卸载该实体，返回值为是否成功。
             * @return {Boolean}
             */
             Unload();

            /**
             *  实体的名字，如果实体是玩家，则返回玩家名\n
             *  前置条件：IS_ALIVE
             */
            name: string;

            /**
             *  实体的血量\n
             *  前置条件：IS_ALIVE
             */
            health: Number;

            /**
             *  实体的最大血量\n
             *  前置条件：IS_ALIVE
             */
            health_max: Number;

            /**
             *  实体的体力\n
             *  前置条件：IS_ALIVE
             */
            stamina: Number;

            /**
             *  实体的体力最大值\n
             *  前置条件：IS_ALIVE
             */
            stamina_max: Number;

            /**
             *  实体的饱食度\n
             *  前置条件：IS_ALIVE
             */
            food: Number;

            /**
             *  实体的饱食度最大值\n
             *  前置条件：IS_ALIVE
             */
            food_max: Number;

            /**
             *  实体的口渴值\n
             *  前置条件：IS_ALIVE
             */
            water: Number;

            /**
             *  实体的口渴值最大值\n
             *  前置条件：IS_ALIVE
             */
            water_max: Number;

            /**
             *  实体的体温值\n
             *  前置条件：IS_ALIVE
             */
            coretemp: Number;

            /**
             *  实体的体温最大值\n
             *  前置条件：IS_ALIVE
             */
            coretemp_max: Number;

            /**
             *  死亡次数\n
             *  前置条件：IS_ALIVE
             */
            died: Number;

            /**
             *  杀死玩家数量\n
             *  前置条件：IS_ALIVE
             */
            killedplayers: Number;
            
            /**
             *  杀死僵尸数量\n
             *  前置条件：IS_ALIVE
             */
            killedzombies: Number;
            
            /**
             *  得分\n
             *  前置条件：IS_ALIVE
             */
            score: Number;
			
            /**
             *  是否正在攀爬\n
             *  前置条件：IS_ALIVE
             */
            is_climbing: Boolean;

            /**
             * 获取实体上的CVar，此CVar为XML或者MOD中定义的CVar\n
             * 前置条件：IS_ALIVE
             * @param  {string} cvar_name cvar_name: CVar的名称
             * @return {string}
             */
             GetCVar(cvar_name);


            /**
             * 设置实体上的CVar，此CVar为XML或者MOD中定义的CVar\n
             * 前置条件：IS_ALIVE
             * @param  {string} cvar_name cvar_name: CVar的名称
             * @param  {string} cvar_value cvar_value: CVar的值
             * @return {void}
             */
             SetCVar(cvar_name, cvar_value);
            
            /**
             * 检查实体是否附有相应的BUFF\n
             * 前置条件：IS_ALIVE
             * @param  {string} buffName buffName: Buff名称
             * @return {Boolean}
             */
             HasBuff(buffName);

            /**
             * 为实体附加相应BUFF\n
             * 前置条件：IS_ALIVE
             * @param  {string} buffName buffName: Buff名称
             * @return {void}
             */
             AddBuff(buffName);

            /**
             * 为实体移除相应BUFF\n
             * 前置条件：IS_ALIVE
             * @param  {string} buffName buffName: Buff名称
             * @return {void}
             */
             RemoveBuff(buffName);

             /**
             * 让该实体跌倒，返回值为是否成功\n
             * 前置条件：IS_ALIVE
             * @param  {Number} [stunTime] stunTime: 倒地时间，可选，默认为2秒
             * @return {Boolean}
             */
             DoRagDoll(stunTime);

            /**
             *  是否具有管理权限(注：在NAIWAZI Serverkit的服务端上此项无效)\n
             *  前置条件：IS_PLAYER
             */
             is_admin: Boolean;

            /**
             *  获取玩家的游戏阶段\n
             *  前置条件：IS_PLAYER
             */
             gamestage: Number;


            /**
             *  获取玩家的跳跃高度\n
             *  前置条件：IS_PLAYER
             */
             jumpstrenth: Number;

            /**
             *  玩家是否是组队的队长\n
             *  前置条件：IS_PLAYER
             */
             is_teamleader: Boolean;

            /**
             *  获取玩家的用户ID(原SteamID)\n
             *  前置条件：IS_PLAYER
             */
             steamid: string;

            /**
             * 获取组队玩家的队员EntityID列表\n
             * 前置条件：IS_PLAYER
             * @return {Array<Number>}
             */
             GetTeamMemberIds();

            /**
             * 获取组队队长的EntityID\n
             * 前置条件：IS_PLAYER
             * @return {Number}
             */
             GetTeamLeaderId();

            /**
             * 获取组队中成员数量\n
             * 前置条件：IS_PLAYER
             * @return {Number}
             */
             GetTeamMemberCount();

            /**
             * 获取玩家组队编号\n
             * 前置条件：IS_PLAYER
             * @return {Number}
             */
             GetTeamId();

            /**
             * 是否和另一个玩家在同组队伍中\n
             * 前置条件：IS_PLAYER
             * @param  {Number} otherId otherId: 另一个玩家的EntityID
             * @return {Boolean}
             */
             IsInSameTeam(otherId);

            /**
             * 获取当前玩家的背包物品列表\n
             * 前置条件：IS_PLAYER
             * @return {Array<NaiwaziObject_Item>}
             */
             GetBag() {
                  ${NaiwaziEditor_ItemDeclare}
             };
             
             /**
             * 获取当前玩家的腰带物品列表\n
             * 前置条件：IS_PLAYER
             * @return {Array<NaiwaziObject_Item>}
             */
              GetToolbelt() {
                  ${NaiwaziEditor_ItemDeclare}
             };

             /**
             * 获取当前玩家的装备列表\n
             * 前置条件：IS_PLAYER
             * @return {Array<NaiwaziObject_Item>}
             */
              GetEquipment() {
                  ${NaiwaziEditor_ItemDeclare}
             };

            /**
             * 是否和另一个玩家是好友关系\n
             * 前置条件：IS_PLAYER
             * @param  {Number} otherId otherId: 另一个玩家的EntityID
             * @return {Boolean}
             */
             IsFriendsWith(otherId);
             

             /**
             * 获取该玩家的好友列表，返回值是用户ID(原SteamID)组成的数组\n
             * 前置条件：IS_PLAYER
             * @return {Array<string>}
             */
              GetFriendsList();


            /**
             * 获取该玩家的领地石数量\n
             * 前置条件：IS_PLAYER
             * @return {Number}
             */
             GetLandClaimsCount();
            
            /**
             * 获取该玩家的相应领地石的坐标X\n
             * 前置条件：IS_PLAYER
             * @param  {Number} index index: 该玩家的领地石编号，即第几个领地石。
             * @return {Number}
             */
             GetLandClaimXAt(index);

             /**
             * 获取该玩家的相应领地石的坐标Y\n
             * 前置条件：IS_PLAYER
             * @param  {Number} index index: 该玩家的领地石编号，即第几个领地石。
             * @return {Number}
             */
              GetLandClaimYAt(index);

            /**
             * 获取该玩家的相应领地石的坐标Z\n
             * 前置条件：IS_PLAYER
             * @param  {Number} index index: 该玩家的领地石编号，即第几个领地石。
             * @return {Number}
             */
             GetLandClaimZAt(index);

             /**
             * 获取该玩家的睡袋坐标X\n
             * 前置条件：IS_PLAYER
             * @return {Number}
             */
              GetSleepingBagX();

             /**
             * 获取该玩家的睡袋坐标Y\n
             * 前置条件：IS_PLAYER
             * @return {Number}
             */
              GetSleepingBagY();

            /**
             * 获取该玩家的睡袋坐标Z\n
             * 前置条件：IS_PLAYER
             * @return {Number}
             */
             GetSleepingBagZ();
      }
`; 

var NaiwaziEditor_TileDeclare = `
      declare class NaiwaziObject_Tile {
            /**
             *  获取原生模式编程的物块实体类对象
             */
            gameobject: any;

            /**
             *  是否属于TileEntityWorkstation (工作台类包括熔炉化学台篝火等)
             */
            IS_WORKSTATION: Boolean;

            /**
             *  是否属于TileEntityLandClaim (领地石类)
             */
            IS_LANDCLAIM: Boolean;

            /**
             *  是否属于TileEntityLight (灯类)
             */
            IS_LIGHT: Boolean;

            /**
             *  是否属于TileEntityLootContainer (容器类)
             */
            IS_LOOTCONTAINER: Boolean;
            
            /**
             *  是否属于TileEntityPowered (电器类)
             */
            IS_POWERED: Boolean;
            
            /**
             *  是否属于 TileEntitySecure (可上锁类)\n
             *  注：TileEntitySecure (可上锁类) 继承于 TileEntityLootContainer (容器类)
             */
            IS_SECURE: Boolean;

            /**
             *  是否属于 TileEntitySecureDoor (可上锁的门类)\n
             *  注：TileEntitySecureDoor (可上锁的门类) 继承于 TileEntitySecure (可上锁类)
             */
            IS_SECURE_DOOR: Boolean;

            /**
             *  是否属于 TileEntitySecureLootContainer (可上锁的容器类)\n
             *  注：TileEntitySecureLootContainer (可上锁的容器类) 继承于 TileEntityLootContainer (容器类)
             */
            IS_SECURE_LOOTCONTAINER: Boolean;

            /**
             *  是否属于 TileEntitySecureLootContainerSigned (可上锁可写字的容器类)\n
             *  注：TileEntitySecureLootContainerSigned (可上锁可写字的容器类) 继承于 TileEntitySecureLootContainer (可上锁的容器类)
             */
            IS_SECURE_LOOTCONTAINER_SIGNED: Boolean;

            /**
             *  是否属于 TileEntitySign (可写字的标志类，如木标志牌)
             */
            IS_SIGN: Boolean;

            /**
             *  是否属于 TileEntityTrader (交易对象类，如商人，贩卖机)
             */
            IS_TRADER: Boolean;

            /**
             *  是否属于 TileEntityVendingMachine (交易机器类，如贩卖机)\n
             *  注：TileEntityVendingMachine (交易机器类) 继承于 TileEntityTrader (交易对象类)
             */
            IS_VENDINGMACHINE: Boolean;
            

            /**
             *  是否绑定了Entity（实体）\n
             *  注：所有的Tile必须跟“物块”或者“Entity”之一绑定。
             */
            has_entity: Boolean;

            /**
             *  如果绑定了Entity（实体），返回EntityID\n
             *  注：所有的Tile必须跟“物块”或者“Entity”之一绑定。
             */
            entityid: Number;

            /**
             *  Tile绑定的Entity或者物块的位置坐标X
             */
            x: Number;

            /**
             *  Tile绑定的Entity或者物块的位置坐标Y
             */
            y: Number;

            /**
             *  Tile绑定的Entity或者物块的位置坐标Z
             */
            z: Number;


            /**
             *  获取Tile的拥有者的用户ID, 如果没有则返回undefined
             */
            owner: string;


            /**
             *  是否是系统生成的Tile，如果是玩家放置则返回false，系统生成则返回true，通常用于判断容器能否被搜刮。
             */
             is_wild: Boolean;


            /**
             * 获取Tile绑定的物块信息\n
             * 注：所有的Tile必须跟“物块”或者“Entity”之一绑定。\n
             * 本函数返回对象可资源回收
             * @return {NaiwaziObject_Block}
             */
            GetBlock() {
                  ${NaiwaziEditor_BlockDeclare}
            };

            /**
             * 获取Tile绑定的实体信息\n
             * 注：所有的Tile必须跟“物块”或者“Entity”之一绑定。\n
             * 本函数返回对象可资源回收
             * @return {NaiwaziObject_Entity}
             */
            GetEntity() {
                  ${NaiwaziEditor_EntityDeclare}
            };

            /**
             * 设置Tile的拥有者\n
             * 前置条件：需要owner返回非undefined，返回值为是否成功。
             * @param  {string} ownerId ownerId: 拥有者的用户ID
             * @return {Boolean}
             */
            SetOwner(ownerId);

            /**
             *  工作台是否处于燃烧工作状态\n
             *  前置条件：IS_WORKSTATION
             */
            is_burning: Boolean;

            /**
             * 获取工作台燃料物品列表\n
             * 前置条件：IS_WORKSTATION\n
             * 注：本函数返回对象可资源回收
             * @return {Array<NaiwaziObject_Item>}
             */
             GetFuel() {
                  ${NaiwaziEditor_ItemDeclare}
            };

            /**
             * 获取工作台合成原料物品列表\n
             * 前置条件：IS_WORKSTATION\n
             * 注：本函数返回对象可资源回收
             * @return {Array<NaiwaziObject_Item>}
             */
             GetInput() {
                  ${NaiwaziEditor_ItemDeclare}
            };

            /**
             * 获取工作台合成输出物品列表\n
             * 前置条件：IS_WORKSTATION\n
             * 注：本函数返回对象可资源回收
             * @return {Array<NaiwaziObject_Item>}
             */
             GetOutput() {
                  ${NaiwaziEditor_ItemDeclare}
            };


            /**
             * 获取工作台合成工具列表（如：坩埚，铁砧等）\n
             * 前置条件：IS_WORKSTATION\n
             * 注：本函数返回对象可资源回收
             * @return {Array<NaiwaziObject_Item>}
             */
             GetTools() {
                  ${NaiwaziEditor_ItemDeclare}
            };

            /**
             * 设置工作台的燃料栏物品\n
             * 前置条件：IS_WORKSTATION
             * @param  {Number} index index: 燃料栏格数，即燃料栏第几格。
             * @param  {string} itemName itemName: 物品名称。
             * @param  {Number} count count: 物品数量。
             * @param  {Number} quality quality: 物品品质。
             * @return {void}
             */
             SetFuelAt(index, itemName, count, quality);

            /**
             * 设置工作台的输入物品\n
             * 前置条件：IS_WORKSTATION
             * @param  {Number} index index: 输入栏格数，即输入栏第几格。
             * @param  {string} itemName itemName: 物品名称。
             * @param  {Number} count count: 物品数量。
             * @param  {Number} quality quality: 物品品质。
             * @return {void}
             */
             SetInputAt(index, itemName, count, quality);

             /**
             * 设置工作台的输出物品\n
             * 前置条件：IS_WORKSTATION
             * @param  {Number} index index: 输出栏格数，即输出栏第几格。
             * @param  {string} itemName itemName: 物品名称。
             * @param  {Number} count count: 物品数量。
             * @param  {Number} quality quality: 物品品质。
             * @return {void}
             */
              SetOutputAt(index, itemName, count, quality);

            /**
             * 设置工作台的工具栏（如：坩埚，铁砧等）\n
             * 前置条件：IS_WORKSTATION
             * @param  {Number} index index: 工具栏格数，即工具栏第几格。
             * @param  {string} itemName itemName: 物品名称。
             * @param  {Number} count count: 物品数量。
             * @param  {Number} quality quality: 物品品质。
             * @return {void}
             */
             SetToolsAt(index, itemName, count, quality);

            /**
             * 清空工作台的燃料栏\n
             * 前置条件：IS_WORKSTATION
             * @return {void}
             */
             ClearFuel();

            /**
             * 清空工作台的输入栏\n
             * 前置条件：IS_WORKSTATION
             * @return {void}
             */
             ClearInput();


            /**
             * 清空工作台的输出栏\n
             * 前置条件：IS_WORKSTATION
             * @return {void}
             */
             ClearOutput();

            /**
             * 清空工作台的工具栏\n
             * 前置条件：IS_WORKSTATION
             * @return {void}
             */
             ClearTools();
            
            /**
             *  容器是否为空\n
             *  前置条件：IS_LOOTCONTAINER
             */
             is_container_empty: Boolean;

            /**
             *  容器的格数\n
             *  前置条件：IS_LOOTCONTAINER
             */
             container_size: Number;

             /**
             *  是否被搜刮过\n
             *  前置条件：IS_LOOTCONTAINER
             */
            is_touched: Boolean;
             
            /**
             * 清空容器\n
             * 前置条件：IS_LOOTCONTAINER
             * @return {void}
             */
             ClearContainerItems();

            /**
             * 获取容器中的物品列表\n
             * 前置条件：IS_LOOTCONTAINER
             * @return {Array<NaiwaziObject_Item>}
             */
             GetContainerItems() {
                  ${NaiwaziEditor_ItemDeclare}
             };


             /**
             * 设置容器中的物品\n
             * 前置条件：IS_LOOTCONTAINER
             * @param  {Number} index index: 物品的格数，即容器物品第几格。
             * @param  {string} itemName itemName: 物品名称。
             * @param  {Number} count count: 物品数量。
             * @param  {Number} quality quality: 物品品质。
             * @return {void}
             */
              SetContainerItemAt(index, itemName, count, quality);


            /**
             * 设置容器中为未搜刮状态，如果容器是玩家放置的不可搜刮容器，则会自动设置为可搜刮容器。\n
             * 前置条件：IS_LOOTCONTAINER
             * @return {void}
             */
             SetUnTouched();


            /**
             *  带锁对象的密码哈希值，由于只存储哈希值，不可获得原始密码值\n
             *  前置条件：IS_SECURE 或者 IS_SECURE_LOOTCONTAINER 或者 IS_SIGN
             */
             secure_password_hash: string;

            /**
             *  带锁对象是否拥有密码\n
             *  前置条件：IS_SECURE 或者 IS_SECURE_LOOTCONTAINER 或者 IS_SIGN
             */
             secure_has_password: Boolean;

            /**
             *  带锁对象是否上锁\n
             *  前置条件：IS_SECURE 或者 IS_SECURE_LOOTCONTAINER 或者 IS_SIGN
             */
             secure_is_locked: Boolean;
            
             /**
              * 设置带锁对象的密码\n
              * 前置条件：IS_SECURE 或者 IS_SIGN 或者 IS_SECURE_LOOTCONTAINER，返回值为是否成功。
              * @param  {string} password password: 要设置的密码
              * @return {Boolean}
              */
              SetPassword(password);

            /**
             * 上锁\n
             * 前置条件：IS_SECURE 或者 IS_SIGN 或者 IS_SECURE_LOOTCONTAINER，返回值为是否成功。
             * @return {Boolean}
             */
             SetLocked();

             /**
             * 解锁\n
             * 前置条件：IS_SECURE 或者 IS_SIGN 或者 IS_SECURE_LOOTCONTAINER，返回值为是否成功。
             * @return {Boolean}
             */
             SetUnLocked();


             /**
             *  获取对象的文字\n
             *  前置条件：IS_SECURE_LOOTCONTAINER_SIGNED 或者 IS_SIGN
             */
            text: string;


            /**
             * 设置对象的文字\n
             * 前置条件：IS_SECURE_LOOTCONTAINER_SIGNED 或者 IS_SIGN
             * @param  {string} text text: 设置的文本
             * @return {void}
             */
             SetText(text);

      }
`;

var NaiwaziEditorExtlib = `
/**
 * 内置函数说明：回收资源，提高总体性能，此函数回收的对象为NaiwaziFunc系列内置函数返回的数组或者内置对象。\n
 * 需要回收的对象有以下几类：\n
 * Array(数组), NaiwaziObject_Block(物块信息), NaiwaziObject_Entity(实体), NaiwaziObject_Item(物品信息), NaiwaziObject_Tile(物块实体)
 * @param  {any} object object: 由NaiwaziFunc系列内置函数返回的对象
 * @return {void}
 */
declare function NaiwaziFunc_Recycle(object);

/**
 * 内置函数说明：设置脚本主循环的定时器时间，默认为1000毫秒，最低100毫秒。\n
 * @param  {Number} delay delay: 定时器时间，单位毫秒。
 * @return {void}
 */
declare function NaiwaziFunc_SetMainDelay(delay);

/**
 * 内置函数说明：获取全局设置变量的值，变量定义在settings.xml中Settings标签中，用于可变更的全局设置，此变量会在BOT的UI中显示，方便服主自主设置变量。
 * @param  {string} setting_name setting_name: 变量名称
 * @return {string}
 */
 declare function NaiwaziFunc_GetGlobalSetting(setting_name);

 /**
 * 内置函数说明：向BOT中注册需要回传的玩家聊天信息的前缀，玩家聊天信息中，只有符合前缀的消息才会传至脚本中。
 * @param  {string} prefix prefix: 要设置的消息前缀
 * @return {void}
 */
  declare function NaiwaziFunc_ChatMessagePrefixRegister(prefix);

 /**
 * 内置函数说明：获取游戏中的所有在线玩家。返回值为NaiwaziObject_Entity的数组。\n
 * 注：本函数返回对象可资源回收
 * @return {Array<NaiwaziObject_Entity>}
 */
  declare function NaiwaziFunc_GetPlayers() {
        ${NaiwaziEditor_EntityDeclare}
  };

 /**
  * 内置函数说明：获取游戏中的所有在线玩家的EntityID。返回值为EntityID的数组。\n
  * 注：本函数返回对象可资源回收
  * @return {Array<Number>}
  */
  declare function NaiwaziFunc_GetPlayersIds();
  
 /**
  * 内置函数说明：获取相应组队编号中的队员列表，返回值为NaiwaziObject_Entity的数组。返回值为组员对象的数组，如找不到此组则返回null\n
  * 注：本函数返回对象可资源回收
  * @param  {Number} teamId teamId: 队伍ID
  * @return {Array<NaiwaziObject_Entity>}
  */
  declare function NaiwaziFunc_GetPlayersByTeamID(teamId) {
      ${NaiwaziEditor_EntityDeclare}
  }

 /**
  * 内置函数说明：获取游戏中的所有实体。返回值为NaiwaziObject_Entity的数组。\n
  * 注：本函数返回对象可资源回收
  * @return {Array<NaiwaziObject_Entity>}
  */
  declare function NaiwaziFunc_GetEntities() {
      ${NaiwaziEditor_EntityDeclare}
  }


 /**
  * 内置函数说明：获取游戏中的所有实体的EntityID。返回值为EntityID的数组。\n
  * 注：本函数返回对象可资源回收
  * @return {Array<Number>}
  */
  declare function NaiwaziFunc_GetEntitiesIds();


 /**
  * 内置函数说明：获取游戏中对应EntityID的实体对象\n
  * 注：本函数返回对象可资源回收
  * @param  {Number} entityId entityId: 实体ID
  * @return {NaiwaziObject_Entity}
  */
  declare function NaiwaziFunc_GetEntityByEntityID(entityId) {
      ${NaiwaziEditor_EntityDeclare}
  }


 /**
  * 内置函数说明：根据用户ID获取相应的玩家对象\n
  * 注：本函数返回对象可资源回收
  * @param  {Number} userId userId: 玩家的用户ID
  * @return {NaiwaziObject_Entity}
  */
  declare function NaiwaziFunc_GetEntityBySteamID(userId) {
      ${NaiwaziEditor_EntityDeclare}
  }


 /**
  * 内置函数说明：对一片区域填充物块
  * @param  {string} blockName blockName: 物块名称
  * @param  {Number} x1 x1: 填充区域顶角的 X 值
  * @param  {Number} y1 y1: 填充区域顶角的 Y 值
  * @param  {Number} z1 z1: 填充区域顶角的 Z 值
  * @param  {Number} x2 x2: 填充区域对角的 X 值
  * @param  {Number} y2 y2: 填充区域对角的 Y 值
  * @param  {Number} z2 z2: 填充区域对角的 Z 值
  * @return {void}
  */
  declare function NaiwaziFunc_SetBlocks(blockName, x1, y1, z1, x2, y2, z2);



 /**
  * 内置函数说明：对单格填充物块
  * @param  {string} blockName blockName: 物块名称
  * @param  {Number} x x: 填充坐标的 X 值
  * @param  {Number} y y: 填充坐标的 Y 值
  * @param  {Number} z z: 填充坐标的 Z 值
  * @return {void}
  */
  declare function NaiwaziFunc_SetBlock(blockName, x, y, z);


 /**
  * 内置函数说明：获取指定坐标的物块信息。\n
  * 注：本函数返回对象可资源回收
  * @param  {Number} x x: 坐标的 X 值
  * @param  {Number} y y: 坐标的 Y 值
  * @param  {Number} z z: 坐标的 Z 值
  * @return {NaiwaziObject_Block}
  */
  declare function NaiwaziFunc_GetBlock(x, y, z) {
      ${NaiwaziEditor_BlockDeclare}
  }

 /**
  * 内置函数说明：在指定位置生成实体
  * @param  {string} blockName blockName: 物块名称
  * @param  {string} entityName entityName: 实体名称
  * @param  {Number} x x: 填充坐标的 X 值
  * @param  {Number} y y: 填充坐标的 Y 值
  * @param  {Number} z z: 填充坐标的 Z 值
  * @param  {Number} count count: 生成数量
  * @return {void}
  */
  declare function NaiwaziFunc_SpawnEntity(entityName, x, y, z, count);

 /**
  * 内置函数说明：对指定实体造成伤害
  * @param  {Number} entityId entityId: 实体ID
  * @param  {Number} damage damage: 伤害值
  * @return {void}
  */
  declare function NaiwaziFunc_GiveDamage(entityId, damage);


 /**
  * 内置函数说明：在服务端执行控制台命令
  * @param  {string} cmdline cmdline: 命令
  * @return {void}
  */
  declare function NaiwaziFunc_ExecuteServerCommand(cmdline);

 /**
  * 内置函数说明：在指定EntityID的玩家客户端上执行控制台命令
  * @param  {Number} entityId entityId: 玩家的EntityID
  * @param  {string} cmdline cmdline: 命令
  * @return {void}
  */
  declare function NaiwaziFunc_ExecuteClientCommandByEntityID(entityId, cmdline);

 /**
  * 内置函数说明：在指定用户ID的玩家客户端上执行控制台命令
  * @param  {string} userId userId: 玩家的用户ID
  * @param  {string} cmdline cmdline: 命令
  * @return {void}
  */
  declare function NaiwaziFunc_ExecuteClientCommandBySteamID(userId, cmdline);

 /**
  * 内置函数说明：给指定EntityID的玩家发送物品
  * @param  {Number} entityId entityId: 玩家的EntityID
  * @param  {string} itemName itemName: 物品名称
  * @param  {Number} count count: 物品数量
  * @param  {Number} quality quality: 物品品质
  * @return {void}
  */
  declare function NaiwaziFunc_GiveItemByEntityID(entityId, itemName, count, quality);

 /**
  * 内置函数说明：给指定用户ID(原SteamID)的玩家发送物品
  * @param  {string} userId userId: 玩家的用户ID(原SteamID)
  * @param  {string} itemName itemName: 物品名称
  * @param  {Number} count count: 物品数量
  * @param  {Number} quality quality: 物品品质
  * @return {void}
  */
  declare function NaiwaziFunc_GiveItemBySteamID(userId, itemName, count, quality);


 /**
  * 内置函数说明：发送公告
  * @param  {string} name name: 发送公告显示的名字，如要沿用BOT设置的名称可直接填空字符串，如：NaiwaziFunc_SayPublic('', '公告内容');
  * @param  {string} message message: 公告内容
  * @return {void}
  */
  declare function NaiwaziFunc_SayPublic(name, message);

 /**
  * 内置函数说明：给指定EntityID的玩家发送私聊信息
  * @param  {Number} entityId entityId: 玩家的EntityID
  * @param  {string} name name: 发送私聊显示的名字，如要沿用BOT设置的名称可直接填空字符串，如：NaiwaziFunc_SayPrivateToEntityID(171, '', '私聊内容');
  * @param  {string} message message: 私聊内容
  * @return {void}
  */
  declare function NaiwaziFunc_SayPrivateToEntityID(entityId, name, message);

 /**
  * 内置函数说明：给指定用户ID(原SteamID)的玩家发送私聊信息
  * @param  {string} userId userId: 玩家的用户ID(原SteamID)
  * @param  {string} name name: 发送私聊显示的名字，如要沿用BOT设置的名称可直接填空字符串，如：NaiwaziFunc_SayPrivateToSteamID('EOS_00028bd9eb9a41d48a707d54c3298953', '', '私聊内容');
  * @param  {string} message message: 私聊内容
  * @return {void}
  */
  declare function NaiwaziFunc_SayPrivateToSteamID(userId, name, message);
  
  /**
  * 内置函数说明：给指定用户ID的玩家发送腰带上显示消息和声音
  * @param  {string} userId userId: 玩家的用户ID
  * @param  {string} message message: 私聊内容
  * @param  {string} sound sound: 同时播放的声音，留空字符串为默认声音，如：NaiwaziFunc_SendOnBeltMessageToSteamID('EOS_00022a213857454d89a0735e909790fa', '[FF0000]测试消息，由BOT脚本发送', '');
  * @return {void}
  */
  declare function NaiwaziFunc_SendOnBeltMessageToUserID(userId, message, sound);

 /**
  * 内置函数说明：获取指定位置的Tile(物块实体)
  * @param  {Number} x x: 坐标的 X 值
  * @param  {Number} y y: 坐标的 Y 值
  * @param  {Number} z z: 坐标的 Z 值
  * @return {NaiwaziObject_Tile}
  */
  declare function NaiwaziFunc_GetTileByPos(x, y, z) {
      ${NaiwaziEditor_TileDeclare}
  }

  /**
  * 内置函数说明：获取指定EntityID的Tile(物块实体)
  * @param  {Number} entityId entityId: 关联的实体ID
  * @return {NaiwaziObject_Tile}
  */
  declare function NaiwaziFunc_GetTileByEntityId(entityId) {
      ${NaiwaziEditor_TileDeclare}
  }

  /**
  * 内置函数说明：获取指定范围内的的所有关联物块的Tile(物块实体)
  * @param  {Number} x1 x1: 顶角坐标的 X 值
  * @param  {Number} y1 y1: 顶角坐标的 Y 值
  * @param  {Number} z1 z1: 顶角坐标的 Z 值
  * @param  {Number} x2 x2: 对角坐标的 X 值
  * @param  {Number} y2 y2: 对角坐标的 Y 值
  * @param  {Number} z2 z2: 对角坐标的 Z 值
  * @return {Array<NaiwaziObject_Tile>}
  */
  declare function NaiwaziFunc_GetTilesInRange(x1, y1, z1, x2, y2, z2) {
      ${NaiwaziEditor_TileDeclare}
  }

 /**
  * 内置函数说明：获取游戏时间的天数
  * @return {Number}
  */
  declare function NaiwaziFunc_GetWorldDays();


 /**
  * 内置函数说明：获取游戏时间的小时数
  * @return {Number}
  */
  declare function NaiwaziFunc_GetWorldHours();

 /**
  * 内置函数说明：获取游戏时间的分钟数
  * @return {Number}
  */
  declare function NaiwaziFunc_GetWorldMinutes();

  /**
  * 内置函数说明：获取某个地点，根据x，z的值获取高度。
  * @param  {Number} x x: x坐标
  * @param  {Number} z z：z坐标
  * @return {Number}
  */
  declare function NaiwaziFunc_GetHeightAt(x, z);


 /**
  * 内置函数说明：伪随机数发生器，生成介于min和max之间的整数
  * @param  {Number} min min: 最小值
  * @param  {Number} max max: 最小值
  * @return {Number}
  */
  declare function NaiwaziFunc_EasyRandom(min, max);
  
 /**
  * 内置函数说明：效果计算器，获取游戏中根据所有模组计算变量，用于计算伤害、概率、效果等等
  * @param  {Number}  passiveEffect passiveEffect: 效果类别，具体数值请参考文档
  * @param  {Object}  originalItemValue originalItemValue: 原始相关物品，如果此效果与物品有关，那儿这里传入的是相关物品，此处需要传入Item的gameobject
  * @param  {Number}  originalValue originalValue: 原始数值，此数值为相关效果的原始数值，函数会通过MOD加成等作用与此值进行运算
  * @param  {Object}  entity entity: 相关实体，如果此效果和实体有关，计算效果数值相关联的实体
  * @param  {Object}  recipe recipe: 相关配方，如果此效果与配方有关，那么这里是计算效果数值相关联的配方。
  * @param  {Boolean} calcEquipment calcEquipment: 是否计算装备加成影响。
  * @param  {Boolean} calcHoldingItem calcHoldingItem: 是否计算手持物品加成影响。
  * @param  {Boolean} calcProgression calcProgression: 是否计算技能加成加成影响。
  * @param  {Boolean} calcBuffs calcBuffs: 是否计算Buff加成加成影响。
  * @param  {Boolean} calcChallenges calcChallenges: 是否计算挑战加成加成影响。（V1.0新增）
  * @param  {Number}  craftingTier craftingTier: 制作倍率加成。
  * @param  {Boolean} useMods useMods: 是否计算武器装备上的模组效果加成。
  * @param  {Boolean} useDurability useDurability: 是否计算物品耐久加成。
  * @return {Number}
  */
  declare function NaiwaziFunc_GetEffect(passiveEffect, originalItemValue, originalValue, entity, recipe, calcEquipment, calcHoldingItem, calcProgression, calcBuffs, calcChallenges, craftingTier, useMods, useDurability);
  
 /**
  * 内置函数说明：字符串哈希计算，注意此处的哈希为唯一值，非随机，通常用于计算游戏中的EntityClass的哈希值
  * @param  {String} inputString inputString: 要计算的字符串
  * @return {Number}
  */
  declare function NaiwaziFunc_GetStringHash(inputString);
  
 /**
  * 内置函数说明：获取实体类EntityClass的Native GameObject，此处用于获取实体的实体类，只能用于Native模式脚本。
  * @param  {String} className className: 实体类的类名，如：EntityPlayer, EntityZombie等
  * @return {Object}
  */
  declare function NaiwaziFunc_GetEntityClass(className);

 /**
  * 内置函数说明：创建新的Tile实例。
  * @param  {String} tileName tileName: Tile的类名，如：TileEntityLootContainer, TileEntityVendingMachine等
  * @return {NaiwaziObject_Tile}
  */
  declare function NaiwaziFunc_CreateTile(tileName);

 /**
  * 内置函数说明：根据容器分类名获取容器类，通常用于获取僵尸掉落物的容器类，返回值为GameObject，只能用于Native模式脚本。
  * @param  {String} name name: 容器分类名，如：zPackStrong（可在entityclass.xml中找到）等，
  * @return {Object}
  */
  declare function NaiwaziFunc_GetLootContainer(name);

 /**
  * 内置函数说明：根据标签获取标签类，通常用于执行某些需要FastTag的原生函数，返回值为GameObject，只能用于Native模式脚本。
  * @param  {String} name name: 标签名。
  * @return {Object}
  */
  declare function NaiwaziFunc_ParseFastTags(name);
  
   /**
  * 内置函数说明：让玩家客户端执行指定的GameEvent，即时生效。
  * @param  {String} userid userid: 玩家的userid
  * @param  {String} eventName eventName: GameEvent的名称，可在gameevent.xml中查找
  * @param  {String} actionIdx actionIdx: GameEvent定义中，执行的action的序号。
  * @return {Object}
  */
  declare function NaiwaziFunc_DoGameEventOnClient(userid, eventName, actionIdx);

 /**
  * 内置函数说明：调试专用函数，用于获取某个GameObject的类型。
  * @param  {Object} obj obj: GameObject。
  * @return {String}
  */
  declare function NaiwaziDebug_GetType(obj);

 /**
  * 内置函数说明：获取NaiwaziBot的Web管理接口的访问Token。
  * @return {String}
  */
  declare function NaiwaziBot_GetAdminToken();


 /**
  * 内置函数说明：将自定义的key-value值写入setting.xml文件。
  * @param  {String} key key: 写入的键。
  * @param  {String} value value: 写入的值。
  * @return {Void}
  */
  declare function NaiwaziBot_WriteCustomSetting(key, value);
  
   /**
  * 内置函数说明：读取自定义的key-value值，返回值为键-值对中的值
  * @param  {String} key key: 要读取入的键。
  * @return {String}
  */
  declare function NaiwaziBot_ReadCustomSetting(key);
  
  
 /**
  * 内置BOT类函数说明：获取指定的用户ID(原SteamID)的玩家积分
  * @param  {String} userId userId: 玩家的用户ID(原SteamID)
  * @return {Number}
  */
  declare function NaiwaziBot_GetPoints(userId);

 /**
  * 内置BOT类函数说明：设置指定的用户ID(原SteamID)的玩家积分，返回值为设置后的积分数
  * @param  {String} userId userId: 玩家的用户ID(原SteamID)
  * @param  {Number} number number: 积分数
  * @return {Number}
  */
  declare function NaiwaziBot_SetPoints(userId, number);

 /**
  * 内置BOT类函数说明：增加指定的用户ID(原SteamID)的玩家积分，返回值为增加后的积分数，失败则返回-1
  * @param  {String} userId userId: 玩家的用户ID(原SteamID)
  * @param  {Number} number number: 积分数
  * @return {Number}
  */
  declare function NaiwaziBot_AddPoints(userId, number);

 /**
  * 内置BOT类函数说明：扣除指定的用户ID(原SteamID)的玩家积分，返回值为扣除后的积分数，失败则返回-1
  * @param  {String} userId userId: 玩家的用户ID(原SteamID)
  * @param  {Number} number number: 积分数
  * @return {Number}
  */
  declare function NaiwaziBot_SubPoints(userId, number);

  /**
  * 内置BOT类函数说明：在指定区域禁用指定的玩家聊天指令\n
  * 示例，禁止区域中执行玩家间传送命令：NaiwaziBot_MuteCommand(1000, 0, 1000, 1050, 300, 1050, 'tp');
  * @param  {Number} x1 x1: 区域顶角坐标 X
  * @param  {Number} y1 y1: 区域顶角坐标 Y
  * @param  {Number} z1 z1: 区域顶角坐标 Z
  * @param  {Number} x2 x2: 区域对角坐标 X
  * @param  {Number} y2 y2: 区域对角坐标 Y
  * @param  {Number} z2 z2: 区域对角坐标 Z
  * @param  {string} cmd cmd: 指定指令，字符串，可为以下值：'pt'(领地保护),'buy'(购买物品),'qd'(签到),'tele'(普通回城传送),'tp'(玩家间传送),'sethome'(设置私有传送点),'backhome'(返回私有传送点),'transfer'(转账),'vip'(VIP领取),'lottery'(抽奖)
  * @return {Boolean}
  */
  declare function NaiwaziBot_MuteCommand(x1, y1, z1, x2, y2, z2, cmd);

  /**
  * 内置BOT类函数说明：解除在指定区域禁用指定的玩家聊天指令\n
  * 示例，解除之前设置的区域中禁止执行玩家间传送命令：NaiwaziBot_UnMuteCommand(1000, 0, 1000, 1050, 300, 1050, 'tp');
  * @param  {Number} x1 x1: 区域顶角坐标 X
  * @param  {Number} y1 y1: 区域顶角坐标 Y
  * @param  {Number} z1 z1: 区域顶角坐标 Z
  * @param  {Number} x2 x2: 区域对角坐标 X
  * @param  {Number} y2 y2: 区域对角坐标 Y
  * @param  {Number} z2 z2: 区域对角坐标 Z
  * @param  {string} cmd cmd: 指定指令，字符串，可为以下值：'pt'(领地保护),'buy'(购买物品),'qd'(签到),'tele'(普通回城传送),'tp'(玩家间传送),'sethome'(设置私有传送点),'backhome'(返回私有传送点),'transfer'(转账),'vip'(VIP领取),'lottery'(抽奖)
  * @return {Boolean}
  */
  declare function NaiwaziBot_UnMuteCommand(x1, y1, z1, x2, y2, z2, cmd);

  /**
  * 内置对象说明：日志操作类，用于打印日志，显示在服务端的控制台中。
  */
  declare class NaiwaziLog {
      /**
       * 记录普通类日志，即绿色字体的日志。
       * @param  {String} message message: 日志信息
       * @return {void}
       */
      static Info(message);

      /**
       * 记录警告类日志，即黄色字体的日志。
       * @param  {String} message message: 日志信息
       * @return {void}
       */
      static Warn(message);

      /**
       * 记录错误类日志，即红色字体的日志。
       * @param  {String} message message: 日志信息
       * @return {void}
       */
      static Error(message);
  }

  /**
  * 内置对象说明：原生模式编程对象，获取 GameManager.Instance 实例
  */
  declare class NaiwaziNative_GameManager {

  }

  /**
  * 内置对象说明：原生模式编程对象，获取 ConnectionManager.Instance 实例
  */
  declare class NaiwaziNative_ConnectionManager {

  }

  /**
  * 内置对象说明：原生模式编程对象，获取 GameManager.Instance.World 实例
  */
  declare class NaiwaziNative_World {

  }

`;
